#ifndef __DM_UART_CRESNET_MASTER_H__
#define __DM_UART_CRESNET_MASTER_H__

////////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"

////////////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
/* 0*/DM_MASTER_STATE_IDLE = 0,               //0
/*! 1*/DM_MASTER_STATE_SENDING_DATA,
/*" 2*/DM_MASTER_STATE_INTERPACKET_DELAY,
/*# 3*/DM_MASTER_STATE_WAIT_INTERPACKET_DELAY_END,
/*$ 4*/DM_MASTER_STATE_SENDING_SYNC_LOW,
/*% 5*/DM_MASTER_STATE_SENDING_SYNC_HIGH,                // 5
/*& 6*/DM_MASTER_STATE_SENDING_TOKEN_ID,
/*' 7*/DM_MASTER_STATE_SENDING_TOKEN_LEN,  // sending 0x00
/*( 8*/DM_MASTER_STATE_WAIT_AFTER_TOKEN,  // wait 1.5 char legnth to release bus
/*) 9*/DM_MASTER_STATE_WAIT_FOR_RESPONSE,  // wait up to 10 char legnth for response, after receiving length changes
/** 10*/DM_MASTER_STATE_RECIEVING_LEN,  // 10 response for token
/*+ 11*/DM_MASTER_STATE_RECIEVING_DATA,  // response for token
/*, 12*/DM_MASTER_STATE_PASSING_TO_DEVICE,  // ship it to device driver
/*- 13*/DM_MASTER_STATE_WAIT_FOR_TOKEN_ID,  // wait up to 10 char legnth for response, after receiving length changes
/*. 14*/DM_MASTER_STATE_WAIT_FOR_TOKEN_LEN,  // wait up to 10 char legnth for response, after receiving length changes
/*/ 15*/DM_MASTER_STATE_INTERPACKET_DELAY_AFTER_EMPTY_TOKEN,  // 15
/*0 16*/DM_MASTER_STATE_INTERPACKET_DELAY_AFTER_NONEMPTY_TOKEN,  // 0x10
/*1 17*/DM_MASTER_STATE_SENDING_SYNC_LOW_AFTER_NO_RESPONSE,  // 0x11
/*2 18*/DM_MASTER_STATE_ANALYZE_SENDING_TOKEN_ID,         // 0x12
/*3 19*/DM_MASTER_STATE_ANALYZE__SENDING_TOKEN_LEN,  // 0x13 sending 0x00
/*4 20*/DM_MASTER_STATE_ANALYZE_WAIT_AFTER_TOKEN,  // 0x14 wait 1.5 char legnth to release bus
/*5 21*/DM_MASTER_STATE_ANALYZE_WAIT_FOR_RESPONSE ,  // 0x15 wait up to 10 char legnth for response, after receiving length changes
/*6 22*/DM_MASTER_STATE_DELAY_BEFORE_TOKEN_ID ,           // 0x16
/*7 23*/DM_MASTER_STATE_WAIT_FOR_RX,  // 0x17 wait up to 10 char legnth for any byte
/*8 24*/DM_MASTER_STATE_WAIT_FOR_TX_EMPTY,  // wait 1 char legnth and then check TXEMPTY
/*9 25*/DM_MASTER_STATE_SLAVE_CMD_RCVED,  // in slave mode, process command
/*: 26*/DM_MASTER_STATE_SLAVE_TOKEN_RCVED,  // in slave mode, send a response
/*; 27*/DM_MASTER_STATE_SLAVE_WAIT_TO_GRAB_BUS,  // in slave mode, wait before switching to tx
/*< 28*/DM_MASTER_STATE_SLAVE_SENDING_DATA,  // in slave mode, txmitting
/*= 29*/DM_MASTER_STATE_SLAVE_SENDING_SENDING_TOKEN_ID,  // in slave mode, txmitting
/*> 30*/DM_MASTER_STATE_SLAVE_SENDING_SENDING_TOKEN_LEN,  // in slave mode, txmitting
/*? 31*/DM_MASTER_STATE_SLAVE_WAIT_AFTER_TOKEN,  // wait 1.5 char legnth to release bus
/*@ 32*/DM_MASTER_STATE_SLAVE_PNP_TOKEN_RCVED,  // in slave mode, send a response
/*A 33*/DM_MASTER_STATE_SLAVE_PNP_WAIT_TO_ASSERT_BREAK,  // in slave mode, wait before switching to tx for pnp response
/*B 34*/DM_MASTER_STATE_SLAVE_PNP_ASSERTING_BREAK,  // in slave mode, send pnp response
/*C 35*/DM_MASTER_STATE_SLAVE_PNP_WAIT_AFTER_ASSERTING_BREAK,  // rx should be disabled
/*D 36*/DM_MASTER_STATE_PNP_WAIT_FOR_RESPONSE,  // in host mode, wait time for response break
/*E 37*/DM_MASTER_STATE_PNP_WAIT_AFTER_RESPONSE,  // in host mode, wait time before switching to back to tx
/*F 38*/DM_MASTER_STATE_DELAY_BEFORE_PPN_TOKEN,
/*G 39*/DM_MASTER_STATE_SENDING_PPN_TOKEN,
/*H 40*/DM_MASTER_STATE_WAIT_FOR_TX_EMPTY_AFTER_PPN_TOKEN,
/*I 41*/DM_MASTER_STATE_DELAY_BEFORE_PPN_CMD_BREAK,
/*J 42*/DM_MASTER_STATE_SENDING_PPN_CMD_BREAK,
/*K 43*/DM_MASTER_STATE_BEFORE_SENDING_DATA,              // for tx
/*L 44*/DM_MASTER_STATE_TEST_SWITCH_TO_TX,
/*M 45*/DM_MASTER_STATE_TEST_SWITCH_TO_RX,
/*N 46*/DM_MASTER_STATE_WAIT_BEFORE_SENDING_SYNC_LOW_AFTER_NO_RESPONSE,
/*o 47*/DM_MASTER_STATE_INVALID  // should never be here
}DM_CRESNET_HOST_STATE_ENUM;

////////////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
}
#endif

#endif  //__DM_UART_CRESNET_MASTER_H__










